clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use wf_step1011.dta, clear
capture log close
log using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\log_files\log_step4004.log, replace

*** Population weights
egen sum_age_total = sum(age_total) if smpl2==1, by(year country)
gen pop_wgt =  age_total/sum_age_total


*==============================================================
*				Estimation sample
*==============================================================

reg  ue2_hyst ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1 & year==1971, robust beta 
			
keep if e(sample)


*==============================================================
*				Table 001: Exclude one country at a time
*==============================================================

	
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*					All included
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


reg  ue2_hyst ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			[aw=pop_wgt]  if smpl2==1 & year==1971, robust beta 

outreg2  ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table2004", ///
			replace	dta ctitle("OLS") dec(2) nocons   ///
			sortvar( ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			

			
**** country fixed effects
reg  ue2_hyst ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1 & year==1971, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
	
outreg2  ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table2004", ///
			append	dta ctitle("FE") dec(2) nocons   ///
			sortvar( ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			
			
			
	
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*					No weights
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			 if smpl2==1 & year==1971, robust beta 

outreg2  ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table2004", ///
			append	dta ctitle("OLS: no wgt") dec(2) nocons   ///
			sortvar( ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			

			
**** country fixed effects
reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_*  if smpl2==1 & year==1971, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
	
outreg2  ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table2004", ///
			append	dta ctitle("FE: no wgt") dec(2) nocons   ///
			sortvar( ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			

			
	
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		Population weighted but no normalization at country level
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			[aw=age_total] if smpl2==1 & year==1971, robust beta 

outreg2  ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table2004", ///
			append	dta ctitle("OLS: wgt2") dec(2) nocons   ///
			sortvar( ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			

			
**** country fixed effects
reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=age_total] if smpl2==1 & year==1971, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
	
outreg2  ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table2004", ///
			append	dta ctitle("FE: wgt2") dec(2) nocons   ///
			sortvar( ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			
			
			
	
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		Robust regression (no weights)
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


rreg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			if smpl2==1 & year==1971, nolog

outreg2  ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table2004", ///
			append	dta ctitle("OLS: rreg") dec(2) nocons   ///
			sortvar( ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			

			
**** country fixed effects
rreg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* if smpl2==1 & year==1971, nolog

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
	
outreg2  ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table2004", ///
			append	dta ctitle("FE: rreg") dec(2) nocons   ///
			sortvar( ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			
			
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	
outreg2  ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table2004", append	dta ctitle("OLS") dec(2) nocons ///
			groupvar( ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2 ///
			Controls ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
	
		
log close
	

	
